/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.event.listeners;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import org.enginehub.worldeditcui.config.Colour;
import org.enginehub.worldeditcui.render.LineStyle;
import org.enginehub.worldeditcui.render.RenderSink;
import org.enginehub.worldeditcui.render.RenderStyle;
import org.enginehub.worldeditcui.util.Vector3;
import org.joml.Matrix4fStack;

public final class CUIRenderContext
implements RenderSink {
    private Vector3 cameraPos;
    private float dt;
    private RenderSink delegateSink;

    public Vector3 cameraPos() {
        return this.cameraPos;
    }

    public Matrix4fStack matrixStack() {
        return RenderSystem.getModelViewStack();
    }

    public void applyMatrices() {
    }

    public float dt() {
        return this.dt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withCameraAt(Vector3 pos, Consumer<CUIRenderContext> action) {
        Vector3 oldPos = this.cameraPos;
        this.cameraPos = pos;
        try {
            action.accept(this);
        }
        finally {
            this.cameraPos = oldPos;
        }
    }

    void init(Vector3 cameraPos, float dt, RenderSink sink) {
        this.cameraPos = cameraPos;
        this.dt = dt;
        this.delegateSink = sink;
    }

    void reset() {
        this.cameraPos = null;
        this.delegateSink = null;
    }

    @Override
    public CUIRenderContext color(float r, float g, float b, float alpha) {
        this.delegateSink.color(r, g, b, alpha);
        return this;
    }

    @Override
    public CUIRenderContext color(Colour colour) {
        this.delegateSink.color(colour);
        return this;
    }

    @Override
    public boolean apply(LineStyle line, RenderStyle.RenderType type) {
        return this.delegateSink.apply(line, type);
    }

    @Override
    public CUIRenderContext vertex(double x, double y, double z) {
        this.delegateSink.vertex(x, y, z);
        return this;
    }

    @Override
    public CUIRenderContext beginLineLoop() {
        this.delegateSink.beginLineLoop();
        return this;
    }

    @Override
    public CUIRenderContext endLineLoop() {
        this.delegateSink.endLineLoop();
        return this;
    }

    @Override
    public RenderSink beginLines() {
        this.delegateSink.beginLines();
        return this;
    }

    @Override
    public RenderSink endLines() {
        this.delegateSink.endLines();
        return this;
    }

    @Override
    public CUIRenderContext beginQuads() {
        this.delegateSink.beginQuads();
        return this;
    }

    @Override
    public CUIRenderContext endQuads() {
        this.delegateSink.endQuads();
        return this;
    }

    @Override
    public void flush() {
        this.delegateSink.flush();
    }
}

