/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.render.shapes;

import org.enginehub.worldeditcui.event.listeners.CUIRenderContext;
import org.enginehub.worldeditcui.render.LineStyle;
import org.enginehub.worldeditcui.render.RenderStyle;
import org.enginehub.worldeditcui.render.points.PointCube;
import org.enginehub.worldeditcui.render.shapes.RenderRegion;
import org.enginehub.worldeditcui.util.Vector3;

public class RenderEllipsoid
extends RenderRegion {
    protected static final double TAU = Math.PI * 2;
    protected static final double SUBDIVISIONS = 40.0;
    protected PointCube centre;
    private final Vector3 radii;
    protected final double centreX;
    protected final double centreY;
    protected final double centreZ;

    public RenderEllipsoid(RenderStyle style, PointCube centre, Vector3 radii) {
        super(style);
        this.centre = centre;
        this.radii = radii;
        this.centreX = centre.getPoint().getX() + 0.5;
        this.centreY = centre.getPoint().getY() + 0.5;
        this.centreZ = centre.getPoint().getZ() + 0.5;
    }

    @Override
    public void render(CUIRenderContext ctx) {
        ctx.flush();
        ctx.matrixStack().pushMatrix();
        ctx.matrixStack().translate((float)(this.centreX - ctx.cameraPos().getX()), (float)(this.centreY - ctx.cameraPos().getY()), (float)(this.centreZ - ctx.cameraPos().getZ()));
        ctx.applyMatrices();
        for (LineStyle line : this.style.getLines()) {
            if (!ctx.apply(line, this.style.getRenderType())) continue;
            ctx.color(line);
            this.drawXZPlane(ctx);
            this.drawYZPlane(ctx);
            this.drawXYPlane(ctx);
        }
        ctx.flush();
        ctx.matrixStack().popMatrix();
        ctx.applyMatrices();
    }

    protected void drawXZPlane(CUIRenderContext ctx) {
        int yRad = (int)Math.floor(this.radii.getY());
        for (int yBlock = -yRad; yBlock < yRad; ++yBlock) {
            ctx.beginLineLoop();
            int i = 0;
            while ((double)i <= 40.0) {
                double tempTheta = (double)i * (Math.PI * 2) / 40.0;
                double tempX = this.radii.getX() * Math.cos(tempTheta) * Math.cos(Math.asin((double)yBlock / this.radii.getY()));
                double tempZ = this.radii.getZ() * Math.sin(tempTheta) * Math.cos(Math.asin((double)yBlock / this.radii.getY()));
                ctx.vertex(tempX, yBlock, tempZ);
                ++i;
            }
            ctx.endLineLoop();
        }
        ctx.beginLineLoop();
        int i = 0;
        while ((double)i <= 40.0) {
            double tempTheta = (double)i * (Math.PI * 2) / 40.0;
            double tempX = this.radii.getX() * Math.cos(tempTheta);
            double tempZ = this.radii.getZ() * Math.sin(tempTheta);
            ctx.vertex(tempX, 0.0, tempZ);
            ++i;
        }
        ctx.endLineLoop();
    }

    protected void drawYZPlane(CUIRenderContext ctx) {
        int xRad = (int)Math.floor(this.radii.getX());
        for (int xBlock = -xRad; xBlock < xRad; ++xBlock) {
            ctx.beginLineLoop();
            int i = 0;
            while ((double)i <= 40.0) {
                double tempTheta = (double)i * (Math.PI * 2) / 40.0;
                double tempY = this.radii.getY() * Math.cos(tempTheta) * Math.sin(Math.acos((double)xBlock / this.radii.getX()));
                double tempZ = this.radii.getZ() * Math.sin(tempTheta) * Math.sin(Math.acos((double)xBlock / this.radii.getX()));
                ctx.vertex(xBlock, tempY, tempZ);
                ++i;
            }
            ctx.endLineLoop();
        }
        ctx.beginLineLoop();
        int i = 0;
        while ((double)i <= 40.0) {
            double tempTheta = (double)i * (Math.PI * 2) / 40.0;
            double tempY = this.radii.getY() * Math.cos(tempTheta);
            double tempZ = this.radii.getZ() * Math.sin(tempTheta);
            ctx.vertex(0.0, tempY, tempZ);
            ++i;
        }
        ctx.endLineLoop();
    }

    protected void drawXYPlane(CUIRenderContext ctx) {
        int zRad = (int)Math.floor(this.radii.getZ());
        for (int zBlock = -zRad; zBlock < zRad; ++zBlock) {
            ctx.beginLineLoop();
            int i = 0;
            while ((double)i <= 40.0) {
                double tempTheta = (double)i * (Math.PI * 2) / 40.0;
                double tempX = this.radii.getX() * Math.sin(tempTheta) * Math.sin(Math.acos((double)zBlock / this.radii.getZ()));
                double tempY = this.radii.getY() * Math.cos(tempTheta) * Math.sin(Math.acos((double)zBlock / this.radii.getZ()));
                ctx.vertex(tempX, tempY, zBlock);
                ++i;
            }
            ctx.endLineLoop();
        }
        ctx.beginLineLoop();
        int i = 0;
        while ((double)i <= 40.0) {
            double tempTheta = (double)i * (Math.PI * 2) / 40.0;
            double tempX = this.radii.getX() * Math.cos(tempTheta);
            double tempY = this.radii.getY() * Math.sin(tempTheta);
            ctx.vertex(tempX, tempY, 0.0);
            ++i;
        }
        ctx.endLineLoop();
    }
}

