/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.input;

import java.util.List;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.runtime.IScreenHelper;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.core.util.ReflectionUtil;
import mezz.jei.gui.input.ICharTypedHandler;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.input.handlers.DragRouter;
import mezz.jei.gui.input.handlers.UserInputRouter;
import net.minecraft.class_11905;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_437;

public class ClientInputHandler {
    private final List<ICharTypedHandler> charTypedHandlers;
    private final UserInputRouter inputRouter;
    private final DragRouter dragRouter;
    private final IInternalKeyMappings keybindings;
    private final IScreenHelper screenHelper;
    private final ReflectionUtil reflectionUtil = new ReflectionUtil();

    public ClientInputHandler(List<ICharTypedHandler> charTypedHandlers, UserInputRouter inputRouter, DragRouter dragRouter, IInternalKeyMappings keybindings, IScreenHelper screenHelper) {
        this.charTypedHandlers = charTypedHandlers;
        this.inputRouter = inputRouter;
        this.dragRouter = dragRouter;
        this.keybindings = keybindings;
        this.screenHelper = screenHelper;
    }

    public void onInitGui() {
        this.inputRouter.handleGuiChange();
        this.dragRouter.handleGuiChange();
    }

    public boolean onKeyboardKeyPressedPre(class_437 screen, UserInput input) {
        IGuiProperties guiProperties;
        if (!this.isContainerTextFieldFocused(screen) && (guiProperties = (IGuiProperties)this.screenHelper.getGuiProperties(screen).orElse(null)) != null) {
            return this.inputRouter.handleUserInput(screen, guiProperties, input, this.keybindings);
        }
        return false;
    }

    public boolean onKeyboardKeyPressedPost(class_437 screen, UserInput input) {
        IGuiProperties guiProperties;
        if (this.isContainerTextFieldFocused(screen) && (guiProperties = (IGuiProperties)this.screenHelper.getGuiProperties(screen).orElse(null)) != null) {
            return this.inputRouter.handleUserInput(screen, guiProperties, input, this.keybindings);
        }
        return false;
    }

    public boolean onKeyboardCharTypedPre(class_437 screen, class_11905 event) {
        if (!this.isContainerTextFieldFocused(screen)) {
            return this.handleCharTyped(event);
        }
        return false;
    }

    public void onKeyboardCharTypedPost(class_437 screen, class_11905 event) {
        if (this.isContainerTextFieldFocused(screen)) {
            this.handleCharTyped(event);
        }
    }

    public boolean onGuiMouseClicked(class_437 screen, UserInput input) {
        IGuiProperties guiProperties = this.screenHelper.getGuiProperties(screen).orElse(null);
        if (guiProperties == null) {
            return false;
        }
        boolean handled = this.inputRouter.handleUserInput(screen, guiProperties, input, this.keybindings);
        if (class_310.method_1551().field_1755 == screen && input.is(this.keybindings.getLeftClick())) {
            handled |= this.dragRouter.startDrag(screen, input);
        }
        return handled;
    }

    public boolean onGuiMouseReleased(class_437 screen, UserInput input) {
        IGuiProperties guiProperties = this.screenHelper.getGuiProperties(screen).orElse(null);
        if (guiProperties == null) {
            return false;
        }
        boolean handled = this.inputRouter.handleUserInput(screen, guiProperties, input, this.keybindings);
        if (input.is(this.keybindings.getLeftClick())) {
            handled |= this.dragRouter.completeDrag(screen, input);
        }
        return handled;
    }

    public boolean onGuiMouseScroll(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
        return this.inputRouter.handleMouseScrolled(mouseX, mouseY, scrollDeltaX, scrollDeltaY);
    }

    private boolean handleCharTyped(class_11905 event) {
        return this.charTypedHandlers.stream().filter(ICharTypedHandler::hasKeyboardFocus).anyMatch(handler -> handler.onCharTyped(event));
    }

    private boolean isContainerTextFieldFocused(class_437 screen) {
        return this.reflectionUtil.getFieldWithClass(screen, class_342.class).anyMatch(textField -> textField.method_37303() && textField.method_25370());
    }
}

